<?php	
	/*
	*
	* copyright (c) 2015-2017 Heliac Technologies
	* license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
	*
        * Questa classe consente di stampare una sitemap da inviare ai motori di ricerca
        * Fa uso della classe DbManager per estrarre dal database le informazioni sui contenuti.
        * Questi devono essere passati come parametro in un array associativo dove ogni elemento
        * deve contenere: 
        *	tabella     -> la tabella con i contenuti che si vuole mappare
        *	frequenza   -> la frequenza di aggiornamento dei contenuti
        *	link        -> il link di base della pagina che mostra i contenuti della tabella
        *	colonnaDataCreazione -> la colonna della tabella che contiene e informazioni sulla data dell'ultimo aggiornamento
        */
	class GeneratoreSiteMap {
		private $db;
		private $nomeSito;
		private $tabelle;

		public function __construct($db,$nomeSito,$tabelle) {
			$this->db = $db;
			$this->nomeSito = $nomeSito;
			$this->tabelle = $tabelle;
		}

		public function creaSitemap() {
			$head = '<?xml version="1.0" encoding="UTF-8"?>' . "\n";
			$head .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">' . "\n";
			echo $head;

			foreach($this->tabelle as $elem) {
				$this->creaSezioneSitemap($elem["tabella"],$elem["frequenza"],$elem["link"],$elem["colonnaDataCreazione"]);
			}
			echo"</urlset>";				
		}

		public function creaSezioneSitemap($tabella,$frequenza,$link,$colonnaDataCreazione) {
			$query = "SELECT * FROM $tabella";
			$risQuery = $this->db->eseguiQueryLettura($query);
			while($elem = $risQuery->fetch_assoc()) {
				if($frequenza=="daily") {
                                    $date=date("Y-m-d");
				}
				else {
                                    $date=date("Y-m-d",strtotime($elem[$colonnaDataCreazione]));
				}
				echo"
				<url>
				  <loc>{$this->nomeSito}/$link?id={$elem["id"]}</loc>
				  <lastmod> $date </lastmod>";	
                                  echo"<changefreq>$frequenza</changefreq>";
				echo"</url>\n";
			}
		}
	}
